local t = Def.ActorFrame{};

local function GetSavedScores(pn,i)
	local StepsOrTrail = GetCurrentStepsOrTrail(pn)
	local Profile = PROFILEMAN:GetProfile(pn)
	local Course, PercentScore
	
	if GetCurrentCourse() == nil then return nil else Course = GetCurrentCourse() end
	
	local ScoreList = Profile:GetHighScoreList(Course,StepsOrTrail)
	local Scores = ScoreList:GetHighScores()
	local TopScore = Scores[i]
	
	if TopScore then
		PercentScore = FormatPercentScore(TopScore:GetPercentDP()):gsub("%%","")
	else
		PercentScore = "0.00"
	end
	return PercentScore
end

local function GetDifficultyColor(pn)
	local GetSteps = GetCurrentStepsOrTrail(pn)
	local difficulty = GetSteps:GetDifficulty()
	return difficulty
end

local function IsClearedOrFailed(pn,i)
	local StepsOrTrail = GetCurrentStepsOrTrail(pn)
	local Profile = PROFILEMAN:GetProfile(pn)
	local Course
	
	if GetCurrentCourse() == nil then return nil else Course = GetCurrentCourse() end
	
	local ScoreList = Profile:GetHighScoreList(Course,StepsOrTrail)
	local Scores = ScoreList:GetHighScores()
	local TopScore = Scores[i]
	local Result
	
	if TopScore then
		if TopScore:GetGrade() == 'Grade_Failed' then
			Result = "Failed"
		else
			Result = "Cleared"
		end
	else
		Result = "Not Played"
	end
	return Result
end

if IsPlayerEnabled(PLAYER_1) then
	t[#t+1] = Def.ActorFrame{
		LoadFont("Common Normal")..{
			Name="P1ScoreOne";
			InitCommand=cmd(xy,Left()+56,Top()+90;zoom,0.5;align,1,0;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_1) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1)))
				self:settext(GetSavedScores(PLAYER_1,1) or "0.00")
				self:sleep(0.05):queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P1ScoreTwo";
			InitCommand=cmd(xy,Left()+56+4+56,Top()+90;zoom,0.5;align,1,0;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_1) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1)))
				self:settext(GetSavedScores(PLAYER_1,2) or "0.00")
				self:sleep(0.05):queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P1ScoreThree";
			InitCommand=cmd(xy,Left()+56*2+4*2+56,Top()+90;zoom,0.5;align,1,0;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_1) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1)))
				self:settext(GetSavedScores(PLAYER_1,3) or "0.00")
				self:sleep(0.05):queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P1FailedOrCleared";
			InitCommand=cmd(xy,CenterX()-192,Top()+90;zoom,0.5;valign,0;maxwidth,186);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_1) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_1)))
				self:settext(IsClearedOrFailed(PLAYER_1,1) or "?")
				self:uppercase(true):sleep(0.05):queuecommand("Update")
			end;
		};
	};
end

if IsPlayerEnabled(PLAYER_2) then
	t[#t+1] = Def.ActorFrame{
		LoadFont("Common Normal")..{
			Name="P2ScoreOne";
			InitCommand=cmd(xy,Right()-230-4,Top()+90;zoom,0.5;align,1,0;shadowlength,1;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2)))
				self:settext(GetSavedScores(PLAYER_2,1) or "0.00")
				self:sleep(0.05)
				self:queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P2ScoreTwo";
			InitCommand=cmd(xy,Right()-230+56,Top()+90;zoom,0.5;align,1,0;shadowlength,1;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2)))
				self:settext(GetSavedScores(PLAYER_2,2) or "0.00")
				self:sleep(0.05)
				self:queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P2ScoreThree";
			InitCommand=cmd(xy,Right()-230+4+56*2,Top()+90;zoom,0.5;align,1,0;shadowlength,1;maxwidth,102);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2)))
				self:settext(GetSavedScores(PLAYER_2,3) or "0.00")
				self:sleep(0.05)
				self:queuecommand("Update")
			end;
		};
		LoadFont("Common Normal")..{
			Name="P2FailedOrCleared";
			InitCommand=cmd(xy,Right()-55,Top()+90;zoom,0.5;valign,0;maxwidth,186);
			OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Update") end end;
			UpdateCommand=function(self)
				self:diffuse(CustomDifficultyToColor(GetDifficultyColor(PLAYER_2)))
				self:settext(IsClearedOrFailed(PLAYER_2,1) or "?")
				self:uppercase(true):sleep(0.05):queuecommand("Update")
			end;
		};
	};
end

return t